---
title: K3S Cert Management
series: Full Kubernetes Installation
description: "Tutorial for the installation of Automatic SSL Certificates using Let's Encrypt with K3S"
keywords: "K3S Let's Encrypt, K3S automatic SSL Certificates, Kubernetes Let's Encrypt, Kubernetes automatic SSL Certificates"
publish: true
date: 2022-05-02
uuid: 647da2ec-a192-48b4-b816-bbd2ea34d75a
tags:
  - #kind/tutorial
  - #using/kubernetes
  - #using/letsencrypt
---

In this tutorial I will show how to configure automatic SSL certificates for K3S using [Let's Encrypt](https://letsencrypt.org/) [(Archived)](https://web.archive.org/web/20220601150207/https://letsencrypt.org/).

<!-- More -->

You should already have the DNS and the Ingress set up and working.
We start by downloading and applying the cert-manager deployment
```bash
wget -O 02a-cert-manager.yaml https://github.com/cert-manager/cert-manager/releases/download/v1.7.1/cert-manager.yaml
```
and later we add the ClusterIssuer. Remember to change the `${LE_EMAIL}` field.
```yaml
# 02b-cluster-issuer.yaml
apiVersion: cert-manager.io/v1
kind: ClusterIssuer
metadata:
  name: letsencrypt
  namespace: cert-manager
spec:
  acme:
    # You must replace this email address with your own.
    # Let's Encrypt will use this to contact you about expiring
    # certificates, and issues related to your account.
    email: ${LE_EMAIL}
    server: https://acme-v02.api.letsencrypt.org/directory
    privateKeySecretRef:
      # Secret resource that will be used to store the account's private key.
      name: letsencrypt
    # Add a single challenge solver, HTTP01 using nginx
    solvers:
    - http01:
        ingress:
          class: traefik
```

Now you have to remember to add the `tls` section to your ingresses like the following (substituting `${FQDN}` and `${SERVICE}` name).
```yaml
apiVersion: networking.k8s.io/v1
kind: Ingress
metadata:
  name: ingress
  annotations:
    cert-manager.io/cluster-issuer: letsencrypt
spec:
  tls:
  - hosts:
    - ${FQDN}
    secretName: secret-letsencrypt
  rules:
  - host: ${FQDN}
    http:
      paths:
      - path: /
        pathType: Prefix
        backend:
          service:
            name: ${SERVICE}
            port:
              number: 80
```
